<?php

use Illuminate\Support\Facades\Cache;
use Modules\Appearance\Entities\Theme;
use Modules\Appearance\Enums\ThemeVisivilityStatus;

function activeTheme()
{
    $activeTheme = Cache::rememberForever('activeTheme', function () {
        return Theme::where('status', ThemeVisivilityStatus::ACTIVE)->first();
    });
    return $activeTheme;
}

function menuUrl($menu)
{
    if ($menu->source == 'custom'):

        return $menu->url ?? '#';

    elseif ($menu->source == 'category') :
        return route('site.category', ['slug' => $menu['category']->slug]);

    elseif ($menu->source == 'sub-category') :
        return route('site.sub-category', ['slug' => $menu['subCategory']->slug]);

    elseif ($menu->source == 'page') :

        if ($menu->page_id == ""):
            return route('image.albums');
        else:
            return route('site.page', ['slug' => $menu['page']->slug]);
        endif;


    elseif ($menu->source == 'post'):

        return route('article.detail', ['id' => $menu['post']->slug]);

    endif;
}

if (!function_exists('basePath')) {

    /**
     * description
     *
     * @param
     * @return
     */
    function basePath($image)
    {

        if (!blank($image)):
            if ($image->disk == 'local') :

                //return public_path();

                if (strpos(php_sapi_name(), 'cli') !== false || defined('LARAVEL_START_FROM_PUBLIC')) {
                    return url('/');
                } else {
                    return url('/public');
                }
            else :
                return "https://s3." . config('filesystems.disks.s3.region') . ".amazonaws.com/" . config('filesystems.disks.s3.bucket');
            endif;
        endif;

    }
}

if (!function_exists('defaultModeCheck')) {

    /**
     * description
     *
     * @param
     * @return
     */
    function defaultModeCheck()
    {
        $mode = Session::get('mode');
        if ($mode == "") :
            Session::put('mode', data_get(activeTheme(), 'options.mode'));
        endif;
        return Session::get('mode');

    }
}

if (!function_exists('embedUrl')) {
    /**
     * description
     *
     * @param
     * @return
     */
    function embedUrl($url)
    {
        $url = str_replace('watch?v=', 'embed/', $url);
        return $url;
    }
}

if (!function_exists('isFileExist')) {

    /**
     * description
     *
     * @param
     * @return
     */
    function isFileExist($item = '', $file = '')
    {
        if (!blank($item) and !blank($file)) :
            if ($item->disk == 'local') :
                if (strpos(php_sapi_name(), 'cli') !== false || defined('LARAVEL_START_FROM_PUBLIC')) {
                    $file = $file;
                } else {
                    $file = 'public/' . $file;
                }
                if (File::exists($file)) :
                    return true;
                endif;
            else :
                if (Storage::disk('s3')->exists($file)) :
                    return true;
                endif;
            endif;
        endif;

        return false;
    }
}

if (!function_exists('static_asset')) {

    function static_asset($path = '')
    {
        if (strpos(php_sapi_name(), 'cli') !== false || defined('LARAVEL_START_FROM_PUBLIC')) {
            return app('url')->asset($path);
        } else {
            return app('url')->asset('public/' . $path);
        }
    }
}

if (!function_exists('safari_check')) {

    function safari_check()
    {
        if (UserAgentBrowser(\Request()->header('User-Agent')) == 'Apple Safari' || UserAgentBrowser(\Request()->header('User-Agent')) == 'Safari' ||
            UserAgentBrowser(\Request()->header('User-Agent')) == 'Internet Explorer'):
            return true;
        endif;
        return false;
    }

}
if (!function_exists('profile_exist')) {

    function profile_exist($image = '')
    {
        if (strpos(php_sapi_name(), 'cli') !== false || defined('LARAVEL_START_FROM_PUBLIC')) {
            $file = $image;
        } else {
            $file = 'public/' . $image;
        }
        if (File::exists($file)) :
            return true;
        endif;
    }

}


if (!function_exists('date2')) {
    function date2($date = 'Y-m-d', $time = null): string
    {
        $fullMonth = [
            'January' => 'Janeiro',     'january' => 'Janeiro',
            'February' => 'Fevereiro',  'february' => 'Fevereiro',
            'March' => 'Março',         'march' => 'Março',
            'April' => 'Abril',         'april' => 'Abril',
            'May' => 'Maio',            'may' => 'Maio',
            'June' => 'Junho',          'june' => 'Junho',
            'July' => 'Julho',          'july' => 'Julho',
            'August' => 'Agosto',       'august' => 'Agosto',
            'September' => 'Setembro',  'september' => 'Setembro',
            'October' => 'Outubro',     'october' => 'Outubro',
            'November' => 'Novembro',   'november' => 'Novembro',
            'December' => 'Dezembro',   'december' => 'Dezembro',

            'Jan' => 'Jan', 'jan' => 'jan',
            'Feb' => 'Fev', 'feb' => 'fev',
            'Mar' => 'Mar', 'mar' => 'mar',
            'Apr' => 'Abr', 'apr' => 'abr',
            'May' => 'Mai', 'may' => 'mai',
            'Jun' => 'Jun', 'jun' => 'jun',
            'Jul' => 'Jul', 'jul' => 'jul',
            'Aug' => 'Ago', 'aug' => 'ago',
            'Sep' => 'Set', 'sep' => 'set',
            'Oct' => 'Out', 'oct' => 'out',
            'Nov' => 'Nov', 'nov' => 'nov',
            'Dec' => 'Dez', 'dec' => 'dez',

            'Jan' => 'Jan', 'jan' => 'jan',
            'Feb' => 'Fev', 'feb' => 'fev',
            'Mar' => 'Mar', 'mar' => 'mar',
            'Apr' => 'Abr', 'apr' => 'abr',
            'May' => 'Mai', 'may' => 'mai',
            'Jun' => 'Jun', 'jun' => 'jun',
            'Jul' => 'Jul', 'jul' => 'jul',
            'Aug' => 'Ago', 'aug' => 'ago',
            'Sep' => 'Set', 'sep' => 'set',
            'Oct' => 'Out', 'oct' => 'out',
            'Nov' => 'Nov', 'nov' => 'nov',
            'Dec' => 'Dez', 'dec' => 'dez',

            'Monday' => 'Segunda-feira',   'monday' => 'segunda-feira',
            'Tuesday' => 'Terça-feira',    'tuesday' => 'terça-feira',
            'Wednesday' => 'Quarta-feira', 'wednesday' => 'quarta-feira',
            'Thursday' => 'Quinta-feira',  'thursday' => 'quinta-feira',
            'Friday' => 'Sexta-feira',     'friday' => 'sexta-feira',
            'Saturday' => 'Sábado',        'saturday' => 'sábado',
            'Sunday' => 'Domingo',         'sunday' => 'domingo',

            'Mon' => 'Seg', 'mon' => 'seg',
            'Tue' => 'Ter', 'tue' => 'ter',
            'Wed' => 'Qua', 'wed' => 'qua',
            'Thu' => 'Qui', 'thu' => 'qui',
            'Fri' => 'Sex', 'fri' => 'sex',
            'Sat' => 'Sáb', 'sat' => 'sáb',
            'Sun' => 'Dom', 'sun' => 'dom',
        ];

        return str_replace(array_keys($fullMonth), $fullMonth, date($date, strtotime($time??time())));
    }
}
