@extends('site.layouts.app')

@section('content')
    @if(!blank($primarySectionPosts))
        @include('site.partials.home.primary_section', [
            'section' => $primarySection,
            'posts' => $primarySectionPosts,
            'sliderPosts' => $sliderPosts,
        ])
    @endif

    <div class="sg-main-content mb-4">
        <div class="container">
            <div class="row">
                @php
                    $language = LaravelLocalization::setLocale() ?? settingHelper('default_language')
                @endphp
                <div class="col-md-7 col-lg-8 sg-sticky">
                    <div class="theiaStickySidebar">
                        <div class="">
                            <div class="container">
                                <div class="content">
                                    @if(@$adsLastPost->ad_type == 'image')
                                        <a href="{{ data_get($adsLastPost, 'ad_url', '#') ?: '#'}}">
                                            @if(!empty($adsLastPost->original_image))
                                                <img class="img-fluid lazy"
                                                    src="public/{{ @$adsLastPost->original_image }} "
                                                    data-original="public/{{ @$adsLastPost->original_image }}"
                                                    alt="{{ @$adsLastPost->ad_name }}">
                                            @else
                                                <img src="{{static_asset('default-image/default-add-728x90.png') }} " class="img-fluid lazy" alt="{!! $adsLastPost->ad_name !!}">
                                            @endif
                                        </a>
                                    @elseif(@$adsLastPost->ad_type == 'code')
                                        {!! $adsLastPost->ad_code ?? '' !!}
                                    @elseif(@$adsLastPost->ad_type == 'text')
                                        {!! $adsLastPost->ad_text ?? '' !!}
                                    @endif
                                </div>
                            </div>
                        </div>
                        @include('site.partials.home.category_section')
                    </div>
                </div>
                <div class="col-md-5 col-lg-4 sg-sticky">
                    <div class="sg-sidebar theiaStickySidebar">
                        @include('site.partials.right_sidebar_widgets')
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
