<?php //eaa9ccb566de0487e2fdcf626f23bfdc
/** @noinspection all */

namespace Modules\Gallery\Entities {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Album_C;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Album_QB;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Audio_C;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Audio_QB;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_GalleryImage_C;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_GalleryImage_QB;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Image_C;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Image_QB;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Video_C;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Video_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Post_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Post_QB;
    use Modules\Post\Entities\Post;

    /**
     * @property int $id
     * @property string $language
     * @property string $name
     * @property string $slug
     * @property string|null $tabs
     * @property int $order
     * @property string|null $meta_keywords
     * @property string|null $meta_description
     * @property string $disk
     * @property string|null $original_image
     * @property string|null $thumbnail
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_GalleryImage_C|GalleryImage[] $galleryImages
     * @property-read int $gallery_images_count
     * @method HasMany|_IH_GalleryImage_QB galleryImages()
     * @method static _IH_Album_QB onWriteConnection()
     * @method _IH_Album_QB newQuery()
     * @method static _IH_Album_QB on(null|string $connection = null)
     * @method static _IH_Album_QB query()
     * @method static _IH_Album_QB with(array|string $relations)
     * @method _IH_Album_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Album_C|Album[] all()
     * @foreignLinks id,\Modules\Gallery\Entities\GalleryImage,album_id
     * @mixin _IH_Album_QB
     */
    class Album extends Model {}

    /**
     * @property int $id
     * @property string $audio_name
     * @property string $disk
     * @property string $original
     * @property string $audio_mp3
     * @property string $audio_ogg
     * @property string $duration
     * @property string|null $audio_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Post_C|Post[] $posts
     * @property-read int $posts_count
     * @method BelongsToMany|_IH_Post_QB posts()
     * @method static _IH_Audio_QB onWriteConnection()
     * @method _IH_Audio_QB newQuery()
     * @method static _IH_Audio_QB on(null|string $connection = null)
     * @method static _IH_Audio_QB query()
     * @method static _IH_Audio_QB with(array|string $relations)
     * @method _IH_Audio_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Audio_C|Audio[] all()
     * @foreignLinks
     * @mixin _IH_Audio_QB
     */
    class Audio extends Model {}

    /**
     * @property int $id
     * @property string $disk
     * @property int|null $album_id
     * @property string|null $tab
     * @property string|null $title
     * @property bool $is_cover
     * @property string $original_image
     * @property string $thumbnail
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Album|null $album
     * @method BelongsTo|_IH_Album_QB album()
     * @method static _IH_GalleryImage_QB onWriteConnection()
     * @method _IH_GalleryImage_QB newQuery()
     * @method static _IH_GalleryImage_QB on(null|string $connection = null)
     * @method static _IH_GalleryImage_QB query()
     * @method static _IH_GalleryImage_QB with(array|string $relations)
     * @method _IH_GalleryImage_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GalleryImage_C|GalleryImage[] all()
     * @ownLinks album_id,\Modules\Gallery\Entities\Album,id
     * @mixin _IH_GalleryImage_QB
     */
    class GalleryImage extends Model {}

    /**
     * @property int $id
     * @property string $disk
     * @property string $original_image
     * @property string $og_image
     * @property string $thumbnail
     * @property string $big_image
     * @property string $big_image_two
     * @property string $medium_image
     * @property string $medium_image_two
     * @property string $medium_image_three
     * @property string $small_image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Image_QB onWriteConnection()
     * @method _IH_Image_QB newQuery()
     * @method static _IH_Image_QB on(null|string $connection = null)
     * @method static _IH_Image_QB query()
     * @method static _IH_Image_QB with(array|string $relations)
     * @method _IH_Image_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Image_C|Image[] all()
     * @foreignLinks id,\App\User,image_id|id,\Modules\Post\Entities\Post,image_id|id,\Modules\Post\Entities\Post,video_thumbnail_id|id,\Modules\Page\Entities\Page,image_id|id,\Modules\Ads\Entities\Ad,ad_image_id|id,\Modules\Post\Entities\QuizQuestion,image_id|id,\Modules\Post\Entities\QuizResult,image_id|id,\Modules\Post\Entities\QuizAnswer,image_id
     * @mixin _IH_Image_QB
     */
    class Image extends Model {}

    /**
     * @property int $id
     * @property string $video_name
     * @property string $video_thumbnail
     * @property string $disk
     * @property string $original
     * @property string|null $v_144p
     * @property string|null $v_240p
     * @property string|null $v_360p
     * @property string|null $v_480p
     * @property string|null $v_720p
     * @property string|null $v_1080p
     * @property string|null $video_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Video_QB onWriteConnection()
     * @method _IH_Video_QB newQuery()
     * @method static _IH_Video_QB on(null|string $connection = null)
     * @method static _IH_Video_QB query()
     * @method static _IH_Video_QB with(array|string $relations)
     * @method _IH_Video_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Video_C|Video[] all()
     * @foreignLinks id,\Modules\Post\Entities\Post,video_id|id,\Modules\Common\Entities\Cron,video_id
     * @mixin _IH_Video_QB
     */
    class Video extends Model {}
}
