<?php //60d17c43099954d9068edc6fd0798f31
/** @noinspection all */

namespace Modules\User\Entities {

    use Cartalyst\Sentinel\Activations\EloquentActivation;
    use Cartalyst\Sentinel\Persistences\EloquentPersistence;
    use Cartalyst\Sentinel\Reminders\EloquentReminder;
    use Cartalyst\Sentinel\Roles\EloquentRole;
    use Cartalyst\Sentinel\Throttling\EloquentThrottle;
    use Cartalyst\Sentinel\Users\EloquentUser;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\Cartalyst\Sentinel\Activations\_IH_EloquentActivation_C;
    use LaravelIdea\Helper\Cartalyst\Sentinel\Activations\_IH_EloquentActivation_QB;
    use LaravelIdea\Helper\Cartalyst\Sentinel\Persistences\_IH_EloquentPersistence_C;
    use LaravelIdea\Helper\Cartalyst\Sentinel\Persistences\_IH_EloquentPersistence_QB;
    use LaravelIdea\Helper\Cartalyst\Sentinel\Reminders\_IH_EloquentReminder_C;
    use LaravelIdea\Helper\Cartalyst\Sentinel\Reminders\_IH_EloquentReminder_QB;
    use LaravelIdea\Helper\Cartalyst\Sentinel\Roles\_IH_EloquentRole_C;
    use LaravelIdea\Helper\Cartalyst\Sentinel\Roles\_IH_EloquentRole_QB;
    use LaravelIdea\Helper\Cartalyst\Sentinel\Throttling\_IH_EloquentThrottle_C;
    use LaravelIdea\Helper\Cartalyst\Sentinel\Throttling\_IH_EloquentThrottle_QB;
    use LaravelIdea\Helper\Cartalyst\Sentinel\Users\_IH_EloquentUser_C;
    use LaravelIdea\Helper\Cartalyst\Sentinel\Users\_IH_EloquentUser_QB;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Image_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Post_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Post_QB;
    use LaravelIdea\Helper\Modules\User\Entities\_IH_Activation_C;
    use LaravelIdea\Helper\Modules\User\Entities\_IH_Activation_QB;
    use LaravelIdea\Helper\Modules\User\Entities\_IH_Permission_C;
    use LaravelIdea\Helper\Modules\User\Entities\_IH_Permission_QB;
    use LaravelIdea\Helper\Modules\User\Entities\_IH_Role_C;
    use LaravelIdea\Helper\Modules\User\Entities\_IH_Role_QB;
    use LaravelIdea\Helper\Modules\User\Entities\_IH_UserRole_C;
    use LaravelIdea\Helper\Modules\User\Entities\_IH_UserRole_QB;
    use LaravelIdea\Helper\Modules\User\Entities\_IH_User_C;
    use LaravelIdea\Helper\Modules\User\Entities\_IH_User_QB;
    use Modules\Gallery\Entities\Image;
    use Modules\Post\Entities\Post;

    /**
     * @property int $id
     * @property int $user_id
     * @property string $code
     * @property bool $completed
     * @property Carbon|null $completed_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Activation_QB onWriteConnection()
     * @method _IH_Activation_QB newQuery()
     * @method static _IH_Activation_QB on(null|string $connection = null)
     * @method static _IH_Activation_QB query()
     * @method static _IH_Activation_QB with(array|string $relations)
     * @method _IH_Activation_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Activation_C|Activation[] all()
     * @ownLinks user_id,\App\User,id
     * @mixin _IH_Activation_QB
     */
    class Activation extends Model {}

    /**
     * @property int $id
     * @property string $slug
     * @property string $name
     * @property string|null $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Permission_QB onWriteConnection()
     * @method _IH_Permission_QB newQuery()
     * @method static _IH_Permission_QB on(null|string $connection = null)
     * @method static _IH_Permission_QB query()
     * @method static _IH_Permission_QB with(array|string $relations)
     * @method _IH_Permission_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Permission_C|Permission[] all()
     * @mixin _IH_Permission_QB
     */
    class Permission extends Model {}

    /**
     * @property int $id
     * @property string $slug
     * @property string $name
     * @property array|null $permissions
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_EloquentUser_C|EloquentUser[] $users
     * @property-read int $users_count
     * @method BelongsToMany|_IH_EloquentUser_QB users()
     * @property _IH_EloquentUser_C|EloquentUser[] $withUsers
     * @property-read int $with_users_count
     * @method BelongsToMany|_IH_EloquentUser_QB withUsers()
     * @method static _IH_Role_QB onWriteConnection()
     * @method _IH_Role_QB newQuery()
     * @method static _IH_Role_QB on(null|string $connection = null)
     * @method static _IH_Role_QB query()
     * @method static _IH_Role_QB with(array|string $relations)
     * @method _IH_Role_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Role_C|Role[] all()
     * @foreignLinks
     * @mixin _IH_Role_QB
     */
    class Role extends Model {}

    /**
     * @property int $id
     * @property string $email
     * @property string|null $password
     * @property array $permissions
     * @property Carbon|null $last_login
     * @property string|null $first_name
     * @property string|null $last_name
     * @property int|null $image_id
     * @property bool $newsletter_enable
     * @property bool $is_user_banned
     * @property string|null $user_banned_reason
     * @property bool $is_subscribe_banned
     * @property string|null $subscribe_banned_reason
     * @property string|null $about_us
     * @property array|null $social_media
     * @property bool $is_active
     * @property string|null $deactivate_reason
     * @property int|null $firebase_auth_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $profile_image
     * @property bool $is_password_set
     * @property string $phone
     * @property Carbon $dob
     * @property bool $gender
     * @property _IH_EloquentActivation_C|EloquentActivation[] $activations
     * @property-read int $activations_count
     * @method HasMany|_IH_EloquentActivation_QB activations()
     * @property Image|null $image
     * @method BelongsTo|_IH_Image_QB image()
     * @property _IH_EloquentPersistence_C|EloquentPersistence[] $persistences
     * @property-read int $persistences_count
     * @method HasMany|_IH_EloquentPersistence_QB persistences()
     * @property _IH_Post_C|Post[] $posts
     * @property-read int $posts_count
     * @method HasMany|_IH_Post_QB posts()
     * @property _IH_EloquentReminder_C|EloquentReminder[] $reminders
     * @property-read int $reminders_count
     * @method HasMany|_IH_EloquentReminder_QB reminders()
     * @property _IH_EloquentRole_C|EloquentRole[] $roles
     * @property-read int $roles_count
     * @method BelongsToMany|_IH_EloquentRole_QB roles()
     * @property _IH_EloquentThrottle_C|EloquentThrottle[] $throttle
     * @property-read int $throttle_count
     * @method HasMany|_IH_EloquentThrottle_QB throttle()
     * @property Activation $withActivation
     * @method HasOne|_IH_Activation_QB withActivation()
     * @property _IH_EloquentRole_C|EloquentRole[] $withRoles
     * @property-read int $with_roles_count
     * @method BelongsToMany|_IH_EloquentRole_QB withRoles()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @ownLinks image_id,\Modules\Gallery\Entities\Image,id
     * @foreignLinks id,\Cartalyst\Sentinel\Activations\EloquentActivation,user_id|id,\Cartalyst\Sentinel\Persistences\EloquentPersistence,user_id|id,\Cartalyst\Sentinel\Reminders\EloquentReminder,user_id|id,\Modules\Post\Entities\Post,user_id|id,\Modules\Post\Entities\Vote,user_id|id,\Modules\Post\Entities\Comment,user_id|id,\Cartalyst\Sentinel\Throttling\EloquentThrottle,user_id
     * @mixin _IH_User_QB
     */
    class User extends Model {}

    /**
     * @method static _IH_UserRole_QB onWriteConnection()
     * @method _IH_UserRole_QB newQuery()
     * @method static _IH_UserRole_QB on(null|string $connection = null)
     * @method static _IH_UserRole_QB query()
     * @method static _IH_UserRole_QB with(array|string $relations)
     * @method _IH_UserRole_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserRole_C|UserRole[] all()
     * @mixin _IH_UserRole_QB
     */
    class UserRole extends Model {}
}
