<?php //5ecab1d0d96d431ae8bc11139b3b82d4
/** @noinspection all */

namespace Modules\Post\Entities {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Audio_C;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Audio_QB;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Image_QB;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Video_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Category_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Category_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Comment_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Comment_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_PollOption_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_PollOption_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_PollResult_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_PollResult_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Poll_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Poll_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Post_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Post_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_QuizAnswer_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_QuizAnswer_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_QuizQuestion_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_QuizQuestion_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_QuizResult_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_QuizResult_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_RssFeed_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_RssFeed_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_SubCategory_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_SubCategory_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Vote_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Vote_QB;
    use LaravelIdea\Helper\Modules\User\Entities\_IH_User_QB;
    use Modules\Gallery\Entities\Audio;
    use Modules\Gallery\Entities\Image;
    use Modules\Gallery\Entities\Video;
    use Modules\User\Entities\User;

    /**
     * @property int $id
     * @property string $category_name
     * @property string $language
     * @property string $slug
     * @property string|null $meta_description
     * @property string|null $meta_keywords
     * @property int $order
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property bool $is_featured
     * @property _IH_Post_C|Post[] $post
     * @property-read int $post_count
     * @method HasMany|_IH_Post_QB post()
     * @property _IH_RssFeed_C|RssFeed[] $rssFeed
     * @property-read int $rss_feed_count
     * @method HasMany|_IH_RssFeed_QB rssFeed()
     * @property _IH_SubCategory_C|SubCategory[] $subCategory
     * @property-read int $sub_category_count
     * @method HasMany|_IH_SubCategory_QB subCategory()
     * @method static _IH_Category_QB onWriteConnection()
     * @method _IH_Category_QB newQuery()
     * @method static _IH_Category_QB on(null|string $connection = null)
     * @method static _IH_Category_QB query()
     * @method static _IH_Category_QB with(array|string $relations)
     * @method _IH_Category_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Category_C|Category[] all()
     * @foreignLinks id,\Modules\Post\Entities\SubCategory,category_id|id,\Modules\Post\Entities\Post,category_id|id,\Modules\Appearance\Entities\MenuItem,category_id|id,\Modules\Appearance\Entities\ThemeSection,category_id|id,\Modules\Post\Entities\RssFeed,category_id
     * @mixin _IH_Category_QB
     */
    class Category extends Model {}

    /**
     * @property int $id
     * @property int $post_id
     * @property int $user_id
     * @property int|null $comment_id
     * @property string $comment
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Post $post
     * @method BelongsTo|_IH_Post_QB post()
     * @property _IH_Comment_C|Comment[] $reply
     * @property-read int $reply_count
     * @method HasMany|_IH_Comment_QB reply()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Comment_QB onWriteConnection()
     * @method _IH_Comment_QB newQuery()
     * @method static _IH_Comment_QB on(null|string $connection = null)
     * @method static _IH_Comment_QB query()
     * @method static _IH_Comment_QB with(array|string $relations)
     * @method _IH_Comment_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Comment_C|Comment[] all()
     * @ownLinks user_id,\App\User,id|post_id,\Modules\Post\Entities\Post,id|comment_id,\Modules\Post\Entities\Comment,id
     * @foreignLinks id,\Modules\Post\Entities\Comment,comment_id
     * @mixin _IH_Comment_QB
     */
    class Comment extends Model {}

    /**
     * @property int $id
     * @property string $question
     * @property Carbon|null $start_date
     * @property Carbon|null $end_date
     * @property string $auth_required
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_PollOption_C|PollOption[] $pollOptions
     * @property-read int $poll_options_count
     * @method HasMany|_IH_PollOption_QB pollOptions()
     * @property _IH_PollResult_C|PollResult[] $pollResults
     * @property-read int $poll_results_count
     * @method HasMany|_IH_PollResult_QB pollResults()
     * @method static _IH_Poll_QB onWriteConnection()
     * @method _IH_Poll_QB newQuery()
     * @method static _IH_Poll_QB on(null|string $connection = null)
     * @method static _IH_Poll_QB query()
     * @method static _IH_Poll_QB with(array|string $relations)
     * @method _IH_Poll_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Poll_C|Poll[] all()
     * @foreignLinks id,\Modules\Post\Entities\Vote,poll_id|id,\Modules\Post\Entities\PollOption,poll_id|id,\Modules\Widget\Entities\Widget,poll_id|id,\Modules\Post\Entities\PollResult,poll_id
     * @mixin _IH_Poll_QB
     */
    class Poll extends Model {}

    /**
     * @property int $id
     * @property int|null $poll_id
     * @property string|null $option
     * @property int|null $order
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_PollResult_C|PollResult[] $pollresults
     * @property-read int $pollresults_count
     * @method HasMany|_IH_PollResult_QB pollresults()
     * @method static _IH_PollOption_QB onWriteConnection()
     * @method _IH_PollOption_QB newQuery()
     * @method static _IH_PollOption_QB on(null|string $connection = null)
     * @method static _IH_PollOption_QB query()
     * @method static _IH_PollOption_QB with(array|string $relations)
     * @method _IH_PollOption_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PollOption_C|PollOption[] all()
     * @ownLinks poll_id,\Modules\Post\Entities\Poll,id
     * @foreignLinks id,\Modules\Post\Entities\PollResult,poll_option_id
     * @mixin _IH_PollOption_QB
     */
    class PollOption extends Model {}

    /**
     * @property int $id
     * @property int|null $poll_id
     * @property int|null $poll_option_id
     * @property string|null $browser_details
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PollResult_QB onWriteConnection()
     * @method _IH_PollResult_QB newQuery()
     * @method static _IH_PollResult_QB on(null|string $connection = null)
     * @method static _IH_PollResult_QB query()
     * @method static _IH_PollResult_QB with(array|string $relations)
     * @method _IH_PollResult_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PollResult_C|PollResult[] all()
     * @ownLinks poll_option_id,\Modules\Post\Entities\PollOption,id|poll_id,\Modules\Post\Entities\Poll,id
     * @mixin _IH_PollResult_QB
     */
    class PollResult extends Model {}

    /**
     * @property int $id
     * @property string $title
     * @property string $slug
     * @property string $content
     * @property string $language
     * @property int|null $user_id
     * @property int|null $category_id
     * @property int|null $sub_category_id
     * @property string $post_type
     * @property bool $submitted
     * @property int|null $image_id
     * @property bool $visibility
     * @property bool $auth_required
     * @property bool $slider
     * @property int $slider_order
     * @property bool $featured
     * @property int $featured_order
     * @property bool $breaking
     * @property int $breaking_order
     * @property bool $recommended
     * @property int $recommended_order
     * @property bool $editor_picks
     * @property int $editor_picks_order
     * @property bool $scheduled
     * @property string|null $meta_title
     * @property string|null $meta_keywords
     * @property string|null $meta_description
     * @property string|null $tags
     * @property Carbon|null $scheduled_date
     * @property string|null $layout
     * @property int|null $video_id
     * @property string|null $video_url_type
     * @property string|null $video_url
     * @property int|null $video_thumbnail_id
     * @property bool $status
     * @property int $total_hit
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property array|null $contents
     * @property string|null $read_more_link
     * @property _IH_Audio_C|Audio[] $audio
     * @property-read int $audio_count
     * @method BelongsToMany|_IH_Audio_QB audio()
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property _IH_Comment_C|Comment[] $comments
     * @property-read int $comments_count
     * @method HasMany|_IH_Comment_QB comments()
     * @property Image|null $image
     * @method BelongsTo|_IH_Image_QB image()
     * @property _IH_QuizQuestion_C|QuizQuestion[] $quizQuestions
     * @property-read int $quiz_questions_count
     * @method HasMany|_IH_QuizQuestion_QB quizQuestions()
     * @property _IH_QuizResult_C|QuizResult[] $quizResults
     * @property-read int $quiz_results_count
     * @method HasMany|_IH_QuizResult_QB quizResults()
     * @property _IH_Comment_C|Comment[] $replay
     * @property-read int $replay_count
     * @method HasMany|_IH_Comment_QB replay()
     * @property SubCategory|null $subCategory
     * @method BelongsTo|_IH_SubCategory_QB subCategory()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @property Video|null $video
     * @method BelongsTo|_IH_Video_QB video()
     * @property Image|null $videoThumbnail
     * @method BelongsTo|_IH_Image_QB videoThumbnail()
     * @method static _IH_Post_QB onWriteConnection()
     * @method _IH_Post_QB newQuery()
     * @method static _IH_Post_QB on(null|string $connection = null)
     * @method static _IH_Post_QB query()
     * @method static _IH_Post_QB with(array|string $relations)
     * @method _IH_Post_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Post_C|Post[] all()
     * @ownLinks category_id,\Modules\Post\Entities\Category,id|sub_category_id,\Modules\Post\Entities\SubCategory,id|user_id,\App\User,id|image_id,\Modules\Gallery\Entities\Image,id|video_thumbnail_id,\Modules\Gallery\Entities\Image,id|video_id,\Modules\Gallery\Entities\Video,id
     * @foreignLinks id,\Modules\Appearance\Entities\MenuItem,post_id|id,\Modules\Post\Entities\Comment,post_id|id,\App\Reaction,post_id|id,\Modules\Post\Entities\QuizQuestion,post_id|id,\Modules\Post\Entities\QuizResult,post_id
     * @mixin _IH_Post_QB
     */
    class Post extends Model {}

    /**
     * @property int $id
     * @property int|null $quiz_question_id
     * @property int|null $image_id
     * @property string|null $answer_text
     * @property int $is_correct
     * @property int|null $result_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Image|null $image
     * @method BelongsTo|_IH_Image_QB image()
     * @method static _IH_QuizAnswer_QB onWriteConnection()
     * @method _IH_QuizAnswer_QB newQuery()
     * @method static _IH_QuizAnswer_QB on(null|string $connection = null)
     * @method static _IH_QuizAnswer_QB query()
     * @method static _IH_QuizAnswer_QB with(array|string $relations)
     * @method _IH_QuizAnswer_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_QuizAnswer_C|QuizAnswer[] all()
     * @ownLinks quiz_question_id,\Modules\Post\Entities\QuizQuestion,id|image_id,\Modules\Gallery\Entities\Image,id
     * @mixin _IH_QuizAnswer_QB
     */
    class QuizAnswer extends Model {}

    /**
     * @property int $id
     * @property int|null $post_id
     * @property string|null $question
     * @property int|null $image_id
     * @property string|null $description
     * @property int $order
     * @property string|null $answer_format
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Image|null $image
     * @method BelongsTo|_IH_Image_QB image()
     * @property Post|null $post
     * @method BelongsTo|_IH_Post_QB post()
     * @property _IH_QuizAnswer_C|QuizAnswer[] $quizAnswers
     * @property-read int $quiz_answers_count
     * @method HasMany|_IH_QuizAnswer_QB quizAnswers()
     * @method static _IH_QuizQuestion_QB onWriteConnection()
     * @method _IH_QuizQuestion_QB newQuery()
     * @method static _IH_QuizQuestion_QB on(null|string $connection = null)
     * @method static _IH_QuizQuestion_QB query()
     * @method static _IH_QuizQuestion_QB with(array|string $relations)
     * @method _IH_QuizQuestion_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_QuizQuestion_C|QuizQuestion[] all()
     * @ownLinks post_id,\Modules\Post\Entities\Post,id|image_id,\Modules\Gallery\Entities\Image,id
     * @foreignLinks id,\Modules\Post\Entities\QuizAnswer,quiz_question_id
     * @mixin _IH_QuizQuestion_QB
     */
    class QuizQuestion extends Model {}

    /**
     * @property int $id
     * @property int|null $post_id
     * @property int|null $image_id
     * @property string|null $result_title
     * @property string|null $description
     * @property int|null $min_correct
     * @property int|null $max_correct
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Image|null $image
     * @method BelongsTo|_IH_Image_QB image()
     * @property Post|null $post
     * @method BelongsTo|_IH_Post_QB post()
     * @property _IH_QuizAnswer_C|QuizAnswer[] $quizAnswers
     * @property-read int $quiz_answers_count
     * @method HasMany|_IH_QuizAnswer_QB quizAnswers()
     * @method static _IH_QuizResult_QB onWriteConnection()
     * @method _IH_QuizResult_QB newQuery()
     * @method static _IH_QuizResult_QB on(null|string $connection = null)
     * @method static _IH_QuizResult_QB query()
     * @method static _IH_QuizResult_QB with(array|string $relations)
     * @method _IH_QuizResult_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_QuizResult_C|QuizResult[] all()
     * @ownLinks post_id,\Modules\Post\Entities\Post,id|image_id,\Modules\Gallery\Entities\Image,id
     * @mixin _IH_QuizResult_QB
     */
    class QuizResult extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $feed_url
     * @property string $language
     * @property int|null $category_id
     * @property int|null $sub_category_id
     * @property int $post_limit
     * @property bool $auto_update
     * @property bool $show_read_more
     * @property bool $status
     * @property bool $keep_date
     * @property string|null $meta_keywords
     * @property string|null $meta_description
     * @property string|null $tags
     * @property Carbon|null $scheduled_date
     * @property string $layout
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property SubCategory|null $subCategory
     * @method BelongsTo|_IH_SubCategory_QB subCategory()
     * @method static _IH_RssFeed_QB onWriteConnection()
     * @method _IH_RssFeed_QB newQuery()
     * @method static _IH_RssFeed_QB on(null|string $connection = null)
     * @method static _IH_RssFeed_QB query()
     * @method static _IH_RssFeed_QB with(array|string $relations)
     * @method _IH_RssFeed_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RssFeed_C|RssFeed[] all()
     * @ownLinks category_id,\Modules\Post\Entities\Category,id|sub_category_id,\Modules\Post\Entities\SubCategory,id
     * @mixin _IH_RssFeed_QB
     */
    class RssFeed extends Model {}

    /**
     * @property int $id
     * @property string $sub_category_name
     * @property string $slug
     * @property int $category_id
     * @property string $language
     * @property string|null $meta_description
     * @property string|null $meta_keywords
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property _IH_Post_C|Post[] $post
     * @property-read int $post_count
     * @method HasMany|_IH_Post_QB post()
     * @property _IH_RssFeed_C|RssFeed[] $rssFeed
     * @property-read int $rss_feed_count
     * @method HasMany|_IH_RssFeed_QB rssFeed()
     * @method static _IH_SubCategory_QB onWriteConnection()
     * @method _IH_SubCategory_QB newQuery()
     * @method static _IH_SubCategory_QB on(null|string $connection = null)
     * @method static _IH_SubCategory_QB query()
     * @method static _IH_SubCategory_QB with(array|string $relations)
     * @method _IH_SubCategory_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SubCategory_C|SubCategory[] all()
     * @ownLinks category_id,\Modules\Post\Entities\Category,id
     * @foreignLinks id,\Modules\Post\Entities\Post,sub_category_id|id,\Modules\Post\Entities\RssFeed,sub_category_id|id,\Modules\Appearance\Entities\MenuItem,sub_category_id
     * @mixin _IH_SubCategory_QB
     */
    class SubCategory extends Model {}

    /**
     * @property int $id
     * @property int $poll_id
     * @property int|null $user_id
     * @property string $answer
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Vote_QB onWriteConnection()
     * @method _IH_Vote_QB newQuery()
     * @method static _IH_Vote_QB on(null|string $connection = null)
     * @method static _IH_Vote_QB query()
     * @method static _IH_Vote_QB with(array|string $relations)
     * @method _IH_Vote_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Vote_C|Vote[] all()
     * @ownLinks poll_id,\Modules\Post\Entities\Poll,id|user_id,\App\User,id
     * @mixin _IH_Vote_QB
     */
    class Vote extends Model {}
}
