<?php //e8d5f3fcb8d7b3df49f875844db5a051
/** @noinspection all */

namespace Modules\Ads\Entities {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\Modules\Ads\Entities\_IH_AdLocation_C;
    use LaravelIdea\Helper\Modules\Ads\Entities\_IH_AdLocation_QB;
    use LaravelIdea\Helper\Modules\Ads\Entities\_IH_Ad_C;
    use LaravelIdea\Helper\Modules\Ads\Entities\_IH_Ad_QB;
    use LaravelIdea\Helper\Modules\Gallery\Entities\_IH_Image_QB;
    use Modules\Gallery\Entities\Image;

    /**
     * @property int $id
     * @property string|null $ad_name
     * @property string|null $ad_size
     * @property string|null $ad_type
     * @property string|null $ad_url
     * @property string|null $ad_location
     * @property int|null $ad_image_id
     * @property string|null $ad_code
     * @property string|null $ad_text
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Image|null $adImage
     * @method BelongsTo|_IH_Image_QB adImage()
     * @method static _IH_Ad_QB onWriteConnection()
     * @method _IH_Ad_QB newQuery()
     * @method static _IH_Ad_QB on(null|string $connection = null)
     * @method static _IH_Ad_QB query()
     * @method static _IH_Ad_QB with(array|string $relations)
     * @method _IH_Ad_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Ad_C|Ad[] all()
     * @ownLinks ad_image_id,\Modules\Gallery\Entities\Image,id
     * @foreignLinks id,\Modules\Ads\Entities\AdLocation,ad_id|id,\Modules\Widget\Entities\Widget,ad_id|id,\Modules\Appearance\Entities\ThemeSection,ad_id
     * @mixin _IH_Ad_QB
     */
    class Ad extends Model {}

    /**
     * @property int $id
     * @property string $title
     * @property string $unique_name
     * @property int|null $ad_id
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Ad|null $ad
     * @method BelongsTo|_IH_Ad_QB ad()
     * @method static _IH_AdLocation_QB onWriteConnection()
     * @method _IH_AdLocation_QB newQuery()
     * @method static _IH_AdLocation_QB on(null|string $connection = null)
     * @method static _IH_AdLocation_QB query()
     * @method static _IH_AdLocation_QB with(array|string $relations)
     * @method _IH_AdLocation_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AdLocation_C|AdLocation[] all()
     * @ownLinks ad_id,\Modules\Ads\Entities\Ad,id
     * @mixin _IH_AdLocation_QB
     */
    class AdLocation extends Model {}
}
