<?php //bc43c7da0d1e957f3ae029da0bc2c134
/** @noinspection all */

namespace Modules\Appearance\Entities {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\Modules\Ads\Entities\_IH_Ad_QB;
    use LaravelIdea\Helper\Modules\Appearance\Entities\_IH_MenuItem_C;
    use LaravelIdea\Helper\Modules\Appearance\Entities\_IH_MenuItem_QB;
    use LaravelIdea\Helper\Modules\Appearance\Entities\_IH_MenuLocation_C;
    use LaravelIdea\Helper\Modules\Appearance\Entities\_IH_MenuLocation_QB;
    use LaravelIdea\Helper\Modules\Appearance\Entities\_IH_Menu_C;
    use LaravelIdea\Helper\Modules\Appearance\Entities\_IH_Menu_QB;
    use LaravelIdea\Helper\Modules\Appearance\Entities\_IH_ThemeSection_C;
    use LaravelIdea\Helper\Modules\Appearance\Entities\_IH_ThemeSection_QB;
    use LaravelIdea\Helper\Modules\Appearance\Entities\_IH_Theme_C;
    use LaravelIdea\Helper\Modules\Appearance\Entities\_IH_Theme_QB;
    use LaravelIdea\Helper\Modules\Page\Entities\_IH_Page_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Category_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Post_C;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Post_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_SubCategory_QB;
    use Modules\Ads\Entities\Ad;
    use Modules\Page\Entities\Page;
    use Modules\Post\Entities\Category;
    use Modules\Post\Entities\Post;
    use Modules\Post\Entities\SubCategory;

    /**
     * @property int $id
     * @property string $title
     * @property string|null $remark
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_MenuItem_C|MenuItem[] $menu_items
     * @property-read int $menu_items_count
     * @method HasMany|_IH_MenuItem_QB menu_items()
     * @method static _IH_Menu_QB onWriteConnection()
     * @method _IH_Menu_QB newQuery()
     * @method static _IH_Menu_QB on(null|string $connection = null)
     * @method static _IH_Menu_QB query()
     * @method static _IH_Menu_QB with(array|string $relations)
     * @method _IH_Menu_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Menu_C|Menu[] all()
     * @foreignLinks id,\Modules\Appearance\Entities\MenuItem,menu_id|id,\Modules\Appearance\Entities\MenuLocation,menu_id
     * @mixin _IH_Menu_QB
     */
    class Menu extends Model {}

    /**
     * @property int $id
     * @property string $label
     * @property string $language
     * @property int $menu_id
     * @property string $is_mega_menu
     * @property int $order
     * @property int|null $parent
     * @property string $source
     * @property string|null $url
     * @property int|null $page_id
     * @property int|null $category_id
     * @property int|null $post_id
     * @property bool $status
     * @property bool $new_teb
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $sub_category_id
     * @property Post|null $Post
     * @method BelongsTo|_IH_Post_QB Post()
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property _IH_MenuItem_C|MenuItem[] $children
     * @property-read int $children_count
     * @method HasMany|_IH_MenuItem_QB children()
     * @property Menu $menu
     * @method HasOne|_IH_Menu_QB menu()
     * @property Page|null $page
     * @method BelongsTo|_IH_Page_QB page()
     * @property _IH_Post_C|Post[] $postByCategory
     * @property-read int $post_by_category_count
     * @method HasMany|_IH_Post_QB postByCategory()
     * @property SubCategory|null $subCategory
     * @method BelongsTo|_IH_SubCategory_QB subCategory()
     * @method static _IH_MenuItem_QB onWriteConnection()
     * @method _IH_MenuItem_QB newQuery()
     * @method static _IH_MenuItem_QB on(null|string $connection = null)
     * @method static _IH_MenuItem_QB query()
     * @method static _IH_MenuItem_QB with(array|string $relations)
     * @method _IH_MenuItem_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MenuItem_C|MenuItem[] all()
     * @ownLinks parent,\Modules\Appearance\Entities\MenuItem,id|menu_id,\Modules\Appearance\Entities\Menu,id|category_id,\Modules\Post\Entities\Category,id|page_id,\Modules\Page\Entities\Page,id|post_id,\Modules\Post\Entities\Post,id|sub_category_id,\Modules\Post\Entities\SubCategory,id
     * @foreignLinks id,\Modules\Appearance\Entities\MenuItem,parent
     * @mixin _IH_MenuItem_QB
     */
    class MenuItem extends Model {}

    /**
     * @property int $id
     * @property string $title
     * @property string $unique_name
     * @property int|null $menu_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Menu|null $menu
     * @method HasOne|_IH_Menu_QB menu()
     * @property _IH_MenuItem_C|MenuItem[] $menuItem
     * @property-read int $menu_item_count
     * @method HasMany|_IH_MenuItem_QB menuItem()
     * @method static _IH_MenuLocation_QB onWriteConnection()
     * @method _IH_MenuLocation_QB newQuery()
     * @method static _IH_MenuLocation_QB on(null|string $connection = null)
     * @method static _IH_MenuLocation_QB query()
     * @method static _IH_MenuLocation_QB with(array|string $relations)
     * @method _IH_MenuLocation_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MenuLocation_C|MenuLocation[] all()
     * @ownLinks menu_id,\Modules\Appearance\Entities\Menu,id
     * @mixin _IH_MenuLocation_QB
     */
    class MenuLocation extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string|null $slug
     * @property array|null $options
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Theme_QB onWriteConnection()
     * @method _IH_Theme_QB newQuery()
     * @method static _IH_Theme_QB on(null|string $connection = null)
     * @method static _IH_Theme_QB query()
     * @method static _IH_Theme_QB with(array|string $relations)
     * @method _IH_Theme_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Theme_C|Theme[] all()
     * @foreignLinks id,\Modules\Appearance\Entities\ThemeSection,theme_id
     * @mixin _IH_Theme_QB
     */
    class Theme extends Model {}

    /**
     * @property int $id
     * @property int $theme_id
     * @property int $type
     * @property string $label
     * @property int $order
     * @property int|null $category_id
     * @property int|null $ad_id
     * @property int|null $post_amount
     * @property string|null $section_style
     * @property int $is_primary
     * @property bool $status
     * @property string|null $language
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Ad|null $ad
     * @method BelongsTo|_IH_Ad_QB ad()
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property _IH_Post_C|Post[] $post
     * @property-read int $post_count
     * @method HasMany|_IH_Post_QB post()
     * @property _IH_Post_C|Post[] $posts
     * @property-read int $posts_count
     * @method HasMany|_IH_Post_QB posts()
     * @method static _IH_ThemeSection_QB onWriteConnection()
     * @method _IH_ThemeSection_QB newQuery()
     * @method static _IH_ThemeSection_QB on(null|string $connection = null)
     * @method static _IH_ThemeSection_QB query()
     * @method static _IH_ThemeSection_QB with(array|string $relations)
     * @method _IH_ThemeSection_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ThemeSection_C|ThemeSection[] all()
     * @ownLinks ad_id,\Modules\Ads\Entities\Ad,id|category_id,\Modules\Post\Entities\Category,id|theme_id,\Modules\Appearance\Entities\Theme,id
     * @mixin _IH_ThemeSection_QB
     */
    class ThemeSection extends Model {}
}
