<?php //6426dcb91d6077b5d4eefeb48bbd483f
/** @noinspection all */

namespace App {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\_IH_Reaction_C;
    use LaravelIdea\Helper\App\_IH_Reaction_QB;
    use LaravelIdea\Helper\App\_IH_User_C;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\App\_IH_VisitorTracker_C;
    use LaravelIdea\Helper\App\_IH_VisitorTracker_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Modules\Post\Entities\_IH_Post_QB;
    use Modules\Post\Entities\Post;

    /**
     * @property int $id
     * @property int|null $post_id
     * @property string|null $ip_address
     * @property string|null $data_reaction
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Reaction_QB onWriteConnection()
     * @method _IH_Reaction_QB newQuery()
     * @method static _IH_Reaction_QB on(null|string $connection = null)
     * @method static _IH_Reaction_QB query()
     * @method static _IH_Reaction_QB with(array|string $relations)
     * @method _IH_Reaction_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Reaction_C|Reaction[] all()
     * @ownLinks post_id,\Modules\Post\Entities\Post,id
     * @mixin _IH_Reaction_QB
     */
    class Reaction extends Model {}

    /**
     * @property int $id
     * @property string $email
     * @property string|null $password
     * @property string $permissions
     * @property Carbon|null $last_login
     * @property string|null $first_name
     * @property string|null $last_name
     * @property int|null $image_id
     * @property bool $newsletter_enable
     * @property bool $is_user_banned
     * @property string|null $user_banned_reason
     * @property bool $is_subscribe_banned
     * @property string|null $subscribe_banned_reason
     * @property string|null $about_us
     * @property string|null $social_media
     * @property bool $is_active
     * @property string|null $deactivate_reason
     * @property int|null $firebase_auth_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $profile_image
     * @property bool $is_password_set
     * @property string $phone
     * @property Carbon $dob
     * @property bool $gender
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @ownLinks image_id,\Modules\Gallery\Entities\Image,id
     * @foreignLinks id,\Cartalyst\Sentinel\Activations\EloquentActivation,user_id|id,\Cartalyst\Sentinel\Persistences\EloquentPersistence,user_id|id,\Cartalyst\Sentinel\Reminders\EloquentReminder,user_id|id,\Modules\Post\Entities\Post,user_id|id,\Modules\Post\Entities\Vote,user_id|id,\Modules\Post\Entities\Comment,user_id|id,\Cartalyst\Sentinel\Throttling\EloquentThrottle,user_id
     * @mixin _IH_User_QB
     */
    class User extends Model {}

    /**
     * @property int $id
     * @property bool|null $page_type
     * @property string|null $slug
     * @property string|null $url
     * @property string|null $source_url
     * @property string|null $ip
     * @property string|null $agent_browser
     * @property Carbon|null $date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Post|null $post
     * @method BelongsTo|_IH_Post_QB post()
     * @property Post|null $posts
     * @method BelongsTo|_IH_Post_QB posts()
     * @method static _IH_VisitorTracker_QB onWriteConnection()
     * @method _IH_VisitorTracker_QB newQuery()
     * @method static _IH_VisitorTracker_QB on(null|string $connection = null)
     * @method static _IH_VisitorTracker_QB query()
     * @method static _IH_VisitorTracker_QB with(array|string $relations)
     * @method _IH_VisitorTracker_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_VisitorTracker_C|VisitorTracker[] all()
     * @mixin _IH_VisitorTracker_QB
     */
    class VisitorTracker extends Model {}
}
